import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class EmailVerificationPage extends StatefulWidget {
  const EmailVerificationPage({Key? key}) : super(key: key);

  @override
  _EmailVerificationPageState createState() => _EmailVerificationPageState();
}

class _EmailVerificationPageState extends State<EmailVerificationPage> with AppActiveContentMixin {
  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: FormEditorPage(
            heading: 'Email verification',
            description: 'Email Verification is the process of verifying an email address is valid and improving the'
                ' odds that it belongs to a real person.',
            items: [
              SettingItem(
                intId: AppSettings.ID_SS_BOOL_USER_EMAIL_VERIFICATION,
                settingKey: AppSettings.KEY_SS_BOOL_USER_EMAIL_VERIFICATION,
                type: FieldType.switchable,
                leading: 'Manadatory Email Verification',
                description: 'Whether email verification is manadatory for users who register on your site.',
              ),
            ],
          ),
        ),
      ],
    );
  }
}
